#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_location.h>

namespace maps::mrc::db::eye {

VerifiedDetectionLocation::VerifiedDetectionLocation(
        VerificationSource source,
        TId detectionId,
        std::optional<geolib3::Point2> mercatorPos,
        std::optional<Eigen::Quaterniond> rotation)
    : id_(0)
    , source_(source)
    , txnId_(0)
    , detectionId_(detectionId)
    , mercatorPos_(mercatorPos)
{
    if (rotation.has_value()) {
        rotation_ = {
            rotation.value().x(),
            rotation.value().y(),
            rotation.value().z(),
            rotation.value().w()
        };
    }
}

} // namespace maps::mrc::db::eye
