#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <maps/libs/common/include/exception.h>

namespace maps::mrc::db {

Feature::Feature(
    std::string sourceId,
    geolib3::Point2 geodeticPos,
    geolib3::Heading heading,
    const std::string& timestamp,
    mds::Key mdsKey,
    Dataset dataset
) {
    setSourceId(std::move(sourceId));
    setGeodeticPos(geodeticPos);
    setHeading(heading);
    setTimestamp(timestamp);
    setMdsKey(std::move(mdsKey));
    setDataset(dataset);
}

void Feature::updatePublished()
{
    shouldBePublished_ = [this] {
        if (!mercatorPos_.has_value()) {
            return false;
        }
        if (!heading_.has_value()) {
            return false;
        }
        if (!width_.has_value() || !height_.has_value()) {
            return false;
        }
        if (deletedByUser_.value_or(false)) {
            return false;
        }
        if (deletedFromMds_.value_or(false)) {
            return false;
        }
        if (moderatorsShouldBePublished_.has_value()) {
            return moderatorsShouldBePublished_.value();
        }
        // default for legacy
        return automaticShouldBePublished_.value_or(
            isPublished_ || shouldBePublished_.value_or(false));
    }();

    if (!shouldBePublished_.value()) {
        isPublished_ = false;
    } else if (isSynchronouslyPublishable()) {
        isPublished_ = true;
    }
}

} // namespace maps::mrc::db
