#include <maps/wikimap/mapspro/services/mrc/libs/db/include/hypothesis.h>

namespace maps::mrc::db {

Hypothesis::Hypothesis(
    HypothesisType type,
    geolib3::Point2 mercatorPos,
    TId objectId,
    TId commitId,
    TId signId)
    : type_(type)
    , mercatorPos_(mercatorPos)
    , objectId_(objectId)
    , commitId_(commitId)
    , signId_(signId) {}

Hypothesis& Hypothesis::setContext(json::Value context) {
    context_ = std::move(context);
    return *this;
}

Hypothesis& Hypothesis::setFeedbackTaskId(TId id) {
    feedbackTaskId_ = id;
    return *this;
}

} // namespace maps::mrc::db
