#include <maps/wikimap/mapspro/services/mrc/libs/db/include/panorama.h>

namespace maps::mrc::db {

Panorama::Panorama(const std::string& mdsKey,
                   const std::string& mdsSrcKey,
                   chrono::TimePoint date,
                   std::uint64_t sessionId,
                   std::uint32_t orderNum,
                   geolib3::Point2 geodeticPos,
                   float vehicleCourseDeg,
                   float horizontalAngleDeg,
                   float verticalAngleDeg,
                   std::uint32_t tileWidth,
                   std::uint32_t tileHeight,
                   std::uint32_t totalWidth,
                   std::uint32_t totalHeight,
                   std::uint16_t zoomLevel)
    : mdsKey_ {mdsKey}
    , mdsSrcKey_ {mdsSrcKey}
    , date_ {date}
    , sessionId_ {sessionId}
    , orderNum_ {orderNum}
    , geodeticPos_ {geodeticPos}
    , vehicleCourseDeg_ {vehicleCourseDeg}
    , horizontalAngleDeg_ {horizontalAngleDeg}
    , verticalAngleDeg_ {verticalAngleDeg}
    , tileWidth_ {tileWidth}
    , tileHeight_ {tileHeight}
    , totalWidth_ {totalWidth}
    , totalHeight_ {totalHeight}
    , zoomLevel_ {zoomLevel}
{
}

} // namespace maps::mrc::db
