#include "eye/hypothesis_gateway.h"
#include "ride_gateway.h"
#include "ride_utility.h"

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/algorithm/collection.h>

namespace maps::mrc::db {

FeedbackIdToHypothesisTypeMap loadRideHypotheses(
    sql_chemistry::Transaction& txn,
    const Ride& ride)
{
    auto result = FeedbackIdToHypothesisTypeMap{};
    if (ride.isDeleted()) {
        return result;
    }
    auto rideHypotheses = RideHypothesisGateway{txn}.load(
        table::RideHypothesis::rideId == ride.rideId());
    auto hypothesisIds = TIds{};
    for (const RideHypothesis& rideHypothesis : rideHypotheses) {
        hypothesisIds.push_back(rideHypothesis.hypothesisId());
    }
    auto hypothesisById = common::byId(eye::HypothesisGateway{txn}.load(
        eye::table::Hypothesis::id.in(hypothesisIds) &&
        eye::table::Hypothesis::deleted.is(false)));
    auto hypothesisFeedbacks = eye::HypothesisFeedbackGateway{txn}.load(
        eye::table::HypothesisFeedback::hypothesisId.in(hypothesisIds));
    for (const auto& hypothesisFeedback : hypothesisFeedbacks) {
        auto it = hypothesisById.find(hypothesisFeedback.hypothesisId());
        if (it != hypothesisById.end()) {
            result.insert({hypothesisFeedback.feedbackId(), it->second.type()});
        }
    }
    return result;
}

}  // namespace maps::mrc::db
