#include <maps/wikimap/mapspro/services/mrc/libs/db/include/sign_gateway.h>

namespace maps::mrc::db {

TIds SignFeatureGateway::loadFeatureIds(const sql_chemistry::Filter& filter) {
    const db::SignFeatures signFeatures = load(filter);

    TIds featureIds;
    featureIds.reserve(signFeatures.size());

    for (const auto& signFeature: signFeatures) {
        featureIds.push_back(signFeature.featureId());
    }

    std::sort(featureIds.begin(), featureIds.end());
    featureIds.erase(
        std::unique(featureIds.begin(), featureIds.end()),
        featureIds.end()
    );

    return featureIds;
}

TIds SignPanoramaGateway::loadPanoramaIds(const sql_chemistry::Filter& filter)
{
    const db::SignPanoramas signPanoramas = load(filter);

    TIds panoramaIds;
    panoramaIds.reserve(signPanoramas.size());

    for (const auto& signPanorama : signPanoramas) {
        panoramaIds.push_back(signPanorama.panoramaId());
    }

    std::sort(panoramaIds.begin(), panoramaIds.end());
    panoramaIds.erase(std::unique(panoramaIds.begin(), panoramaIds.end()),
                      panoramaIds.end());

    return panoramaIds;
}

} // namespace maps::mrc::db
