#include <maps/wikimap/mapspro/services/mrc/libs/db/include/traffic_light_hypothesis.h>

namespace maps::mrc::db {

TrafficLightHypothesis::TrafficLightHypothesis(
    geolib3::Point2 mercatorPos,
    TId objectId,
    TId commitId,
    TId trafficLightId)
    : mercatorPos_(mercatorPos)
    , objectId_(objectId)
    , commitId_(commitId)
    , trafficLightId_(trafficLightId) {}

TrafficLightHypothesis& TrafficLightHypothesis::setContext(json::Value context) {
    context_ = std::move(context);
    return *this;
}

TrafficLightHypothesis& TrafficLightHypothesis::setFeedbackTaskId(TId id) {
    feedbackTaskId_ = id;
    return *this;
}

} // namespace maps::mrc::db
