#pragma once

#include <vector>

namespace maps::mrc::db {

template <class To, class From>
std::vector<To> castItemsTo(const std::vector<From>& items)
{
    std::vector<To> result;
    result.reserve(items.size());
    for (const auto& item : items) {
        result.push_back(static_cast<To>(item));
    }
    return result;
}

} // namespace maps::mrc::db
