#pragma once

#include "area_of_interest.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct Aoi : Table<db::AreaOfInterest> {
    static constexpr std::string_view name_{"service.aoi"sv};

    static constexpr BigSerialKey id{"aoi_id"sv, name_};
    static constexpr MercatorColumn<geolib3::MultiPolygon2> geom{"geom"sv, name_};
    static constexpr StringColumn name{"name"sv, name_};

    static constexpr auto columns_() { return std::tie(id, geom, name); }
};

} // namespace table

using AoiGateway = sql_chemistry::Gateway<table::Aoi>;

} // namespace maps::mrc::db
