#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <vector>

namespace maps::mrc::db {

class AssignmentObjectFeedbackTask {
public:
    AssignmentObjectFeedbackTask(
        TId objectId,
        std::optional<std::string> feedbackTaskId = std::nullopt)
        : objectId_(objectId)
        , feedbackTaskId_(std::move(feedbackTaskId)) {
        ASSERT(objectId != 0);
    }

    TId objectId() const { return objectId_; }

    const std::optional<std::string>& feedbackTaskId() const { return feedbackTaskId_; }

    AssignmentObjectFeedbackTask& setFeedbackTaskId(std::string feedbackTaskId) {
        feedbackTaskId_ = std::move(feedbackTaskId);
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<AssignmentObjectFeedbackTask>;
    AssignmentObjectFeedbackTask() = default;

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.objectId_, t.feedbackTaskId_); }

    TId objectId_{};
    std::optional<std::string> feedbackTaskId_{};

public:
    auto introspect() const { return introspect(*this); }
};

using AssignmentObjectFeedbackTasks = std::vector<AssignmentObjectFeedbackTask>;

} // namespace maps::mrc::db
