#pragma once

#include "assignment_object_feedback_task.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

#include <yandex/maps/wiki/common/string_utils.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct AssignmentObjectFeedbackTask : Table<db::AssignmentObjectFeedbackTask> {
    static constexpr std::string_view name_{"hypotheses.assignment_object_feedback_task"sv};

    // PRIMARY FOREIGN KEY to ugc.assignment_object
    static constexpr Int64PrimaryKey objectId{"object_id"sv, name_};
    static constexpr NullableStringColumn feedbackTaskId{"feedback_task_id"sv, name_};

    static constexpr auto columns_() { return std::tie(objectId, feedbackTaskId); }
};

} // namespace table

class AssignmentObjectFeedbackTaskGateway
    : public sql_chemistry::Gateway<table::AssignmentObjectFeedbackTask> {
public:
    using Tb = table::AssignmentObjectFeedbackTask;
    using Base = Gateway<Tb>;
    using Base::Gateway;
    using Base::Entities;

    Entities loadWithFeedback(std::optional<size_t> limit = std::nullopt, std::size_t offset = 0) {
        return load(Tb::feedbackTaskId != std::nullopt,
                sql_chemistry::orderBy(Tb::objectId).offset(offset).limit(limit));
    }

    Entities loadWithoutFeedback(std::optional<size_t> limit = std::nullopt, std::size_t offset = 0) {
        return load(Tb::feedbackTaskId == std::nullopt,
                sql_chemistry::orderBy(Tb::objectId).offset(offset).limit(limit));
    }
};

} // namespace maps::mrc::db
