#pragma once

#include "common.h"
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <vector>

namespace maps::mrc::db {

enum class Dataset : int8_t {
    Begin_,  // internal implementation-related value
    Agents = Begin_,
    Drive,
    Rides,
    Walks,
    Video,
    Tehran,
    PedestrianTask,
    BackofficeObject,
    BackofficePhoto,
    AltayPedestrians,
    YangPedestrians,
    NexarDashcams,
    TaxiSignalQ2,
    TolokaPedestrians, // for importing data collected in Toloka NMAPS-14476
    End_,  // internal implementation-related value
};

DECLARE_ENUM_IO(Dataset);


const std::vector<Dataset>& standalonePhotosDatasets();
const std::vector<Dataset>& ridePhotosDatasets();

bool isStandalonePhotosDataset(Dataset dataset);
bool isRidesPhotosDataset(Dataset dataset);
FeaturePrivacy evalPrivacy(Dataset dataset);

} // namespace maps::mrc::db
