#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::mrc::db {

class DisqualifiedSource {
public:
    DisqualifiedSource(DisqType disqType,
                       std::string sourceId,
                       chrono::TimePoint startedAt,
                       std::optional<chrono::TimePoint> endedAt = std::nullopt)
        : disqType_{disqType}
        , sourceId_{std::move(sourceId)}
        , startedAt_{startedAt}
        , endedAt_{std::move(endedAt)}
    {
    }

    TId id() const { return id_; }
    DisqType disqType() const { return disqType_; }
    const std::string& sourceId() const { return sourceId_; }
    chrono::TimePoint startedAt() const { return startedAt_; }
    const std::optional<chrono::TimePoint>& endedAt() const { return endedAt_; }

    DisqualifiedSource& setEndedAt(chrono::TimePoint endedAt)
    {
        endedAt_ = endedAt;
        return *this;
    }

    DisqualifiedSource& resetEndedAt()
    {
        endedAt_ = std::nullopt;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<DisqualifiedSource>;

    DisqualifiedSource() = default;

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(
            t.id_, t.disqType_, t.sourceId_, t.startedAt_, t.endedAt_);
    }

    TId id_{};
    DisqType disqType_{};
    std::string sourceId_{};
    chrono::TimePoint startedAt_{};
    std::optional<chrono::TimePoint> endedAt_{};

public:
    auto introspect() const { return introspect(*this); }
};

using DisqualifiedSources = std::vector<DisqualifiedSource>;

}  // namespace maps::mrc::db
