#pragma once

#include "disqualified_source.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct DisqualifiedSource : Table<db::DisqualifiedSource> {
    static constexpr std::string_view name_{"signals.disqualified_source"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr EnumColumn<DisqType> disqType{"disq_type"sv, name_};
    static constexpr StringColumn sourceId{"source_id"sv, name_};
    static constexpr TimePointColumn startedAt{"started_at"sv, name_};
    static constexpr NullableTimePointColumn endedAt{"ended_at"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id, disqType, sourceId, startedAt, endedAt);
    }
};

}  // namespace table

using DisqualifiedSourceGateway =
    sql_chemistry::Gateway<table::DisqualifiedSource>;

}  // namespace maps::mrc::db
