#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>

#include <optional>
#include <string>

namespace maps::mrc::db::eye {

enum class FrameSource;

struct MrcDeviceAttrs {
    std::optional<std::string> model;
};

struct PanoramaDeviceAttrs {
    geolib3::Degrees horizontalFOV;
};

class DeviceAttrs {
public:
    DeviceAttrs(const json::Value& value);
    DeviceAttrs(const MrcDeviceAttrs& attrs);
    DeviceAttrs(const PanoramaDeviceAttrs& attrs);

    const json::Value& json() const;

    FrameSource source() const;

    MrcDeviceAttrs mrc() const;

    PanoramaDeviceAttrs panorama() const;

private:
    json::Value value_;
};

} // maps::mrc::db::eye
