#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <string>
#include <utility>

namespace maps::mrc::db::eye {

class FeatureToFrame {

public:
    FeatureToFrame(TId featureId, TId frameId): featureId_(featureId), frameId_(frameId) {}

    TId featureId() const { return featureId_; }

    TId frameId() const { return frameId_; }

private:
    friend class sql_chemistry::GatewayAccess<FeatureToFrame>;

    FeatureToFrame() {};

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.featureId_, t.frameId_); }

    TId featureId_;
    TId frameId_;

public:
    auto introspect() const { return introspect(*this); }
};

class FeatureSourceToDevice {

public:
    FeatureSourceToDevice(std::string sourceId, TId deviceId)
        : sourceId_(std::move(sourceId))
        , deviceId_(deviceId)
    {}

    const std::string sourceId() const { return sourceId_; }

    TId deviceId() const { return deviceId_; }

private:
   friend class sql_chemistry::GatewayAccess<FeatureSourceToDevice>;

    FeatureSourceToDevice() {};

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.sourceId_, t.deviceId_); }

    std::string sourceId_;
    TId deviceId_;

public:
    auto introspect() const { return introspect(*this); }
};

} // namespace maps::mrc::db::eye
