#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/feature.h>
#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::eye {

namespace table {

using namespace sql_chemistry;

struct FeatureToFrame: Table<db::eye::FeatureToFrame> {
    static constexpr std::string_view name_{"eye.feature_to_frame"sv};

    static constexpr Int64PrimaryKey featureId{"feature_id"sv, name_};
    static constexpr NumericColumn<TId> frameId{"frame_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(featureId, frameId);
    }
};

struct FeatureSourceToDevice: Table<db::eye::FeatureSourceToDevice> {
    static constexpr std::string_view name_{"eye.feature_source_to_device"sv};

    static constexpr StringPrimaryKey sourceId{"source_id"sv, name_};
    static constexpr NumericColumn<TId> deviceId{"device_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(sourceId, deviceId);
    }
};

} // namespace table

using FeatureToFrameGateway = sql_chemistry::Gateway<table::FeatureToFrame>;
using FeatureSourceToDeviceGateway = sql_chemistry::Gateway<table::FeatureSourceToDevice>;

} // namespace maps::mrc::db::eye