#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/enums.h>

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/rd.h>
#include <maps/libs/ymapsdf/include/ft.h>
#include <maps/libs/json/include/value.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <maps/wikimap/mapspro/libs/revision/include/yandex/maps/wiki/revision/revisionid.h>

namespace maps::mrc::db::eye {

enum class HypothesisType {
    AbsentTrafficLight,
    AbsentHouseNumber,
    WrongSpeedLimit,
    AbsentParking,
    WrongParkingFtType,
    TrafficSign,
    WrongDirection,
    ProhibitedPath,
    LaneHypothesis,
    SpeedBump,
    RailwayCrossing,
};

DECLARE_ENUM_IO(HypothesisType);

using HypothesisTypes = std::vector<HypothesisType>;

struct AbsentTrafficLightAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::AbsentTrafficLight;

    static AbsentTrafficLightAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID junctionRevisionId;
};

json::Value toJson(const AbsentTrafficLightAttrs& attrs);


struct AbsentHouseNumberAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::AbsentHouseNumber;

    static AbsentHouseNumberAttrs fromJson(const json::Value& value);

    std::string number;
};

json::Value toJson(const AbsentHouseNumberAttrs& attrs);


struct TrafficSignAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::TrafficSign;

    static TrafficSignAttrs fromJson(const json::Value& value);

    wiki::social::feedback::Type feedbackType;
};

json::Value toJson(const TrafficSignAttrs& attrs);


struct WrongSpeedLimitAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::WrongSpeedLimit;

    static WrongSpeedLimitAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID roadElementRevisionId;
    int correctSpeedLimit;
    std::optional<int> currentSpeedLimit;
    std::optional<ymapsdf::rd::Direction> direction;
    std::optional<bool> truck;
};

json::Value toJson(const WrongSpeedLimitAttrs& attrs);


struct WrongDirectionAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::WrongDirection;

    static WrongDirectionAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID roadElementRevisionId;
    maps::mrc::object::RoadElement::Direction supposedDirection;
    maps::mrc::object::RoadElement::Direction currentDirection;
};

json::Value toJson(const WrongDirectionAttrs& attrs);


struct ProhibitedPathAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::ProhibitedPath;

    static ProhibitedPathAttrs fromJson(const json::Value& value);

    wiki::social::feedback::Movement movement;
    geolib3::Polyline2 mercatorPath;
};

json::Value toJson(const ProhibitedPathAttrs& attrs);


struct AbsentParkingAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::AbsentParking;

    static AbsentParkingAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID parkingRevisionId;
    bool isToll = false;
};

json::Value toJson(const AbsentParkingAttrs& attrs);


struct WrongParkingFtTypeAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::WrongParkingFtType;

    static WrongParkingFtTypeAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID parkingRevisionId;
    ymapsdf::ft::Type correctFtType;
    ymapsdf::ft::Type currentFtType;
};

json::Value toJson(const WrongParkingFtTypeAttrs& attrs);


struct LaneHypothesisAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::LaneHypothesis;

    static LaneHypothesisAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID roadElementRevisionId;
};

json::Value toJson(const LaneHypothesisAttrs& attrs);

struct SpeedBumpAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::SpeedBump;

    static SpeedBumpAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID objectRevisionId;
    // true - гипотеза основана на знаке 1.17 (предупреждающий знак, красный)
    // false - гипотеза основана на знаке 5.20 (знак особых предписаний, синий)
    bool isAhead;
};

json::Value toJson(const SpeedBumpAttrs& attrs);


struct RailwayCrossingAttrs {
    static const HypothesisType HYPOTHESIS_TYPE = HypothesisType::RailwayCrossing;

    static RailwayCrossingAttrs fromJson(const json::Value& value);

    wiki::revision::RevisionID objectRevisionId;
    bool hasBarrier;
};

json::Value toJson(const RailwayCrossingAttrs& attrs);

} // namespace maps::mrc::db::eye
