#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/txn_id.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

namespace maps::mrc::db {
namespace eye {
namespace table {

using namespace sql_chemistry;

struct Hypothesis : Table<db::eye::Hypothesis> {
    static constexpr std::string_view name_{"eye.hypothesis"sv};

    static constexpr BigSerialKey id{"hypothesis_id"sv, name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};
    static constexpr BooleanColumn deleted{"deleted", name_};
    static constexpr MercatorColumn<geolib3::Point2> position{"position"sv, name_};
    static constexpr EnumColumn<HypothesisType> type{"type", name_};
    static constexpr JsonColumn attrs{"attrs"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id, txnId, deleted, position, type, attrs);
    }
};

struct HypothesisObject : Table<db::eye::HypothesisObject> {
    static constexpr std::string_view name_{"eye.hypothesis_object"sv};
    static constexpr BigSerialKey id{"hypothesis_object_id"sv, name_};
    static constexpr NumericColumn<TId> hypothesisId{"hypothesis_id"sv, name_};
    static constexpr NumericColumn<TId> objectId{"object_id"sv, name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};
    static constexpr BooleanColumn deleted{"deleted", name_};

    static constexpr auto columns_()
    {
        return std::tie(id, hypothesisId, objectId, txnId, deleted);
    }
};

struct HypothesisFeedback : Table<db::eye::HypothesisFeedback> {
    static constexpr std::string_view name_{"eye.hypothesis_feedback"sv};
    static constexpr NumericColumn<TId> hypothesisId{"hypothesis_id"sv, name_};
    static constexpr NumericColumn<TId> feedbackId{"feedback_id"sv, name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(hypothesisId, feedbackId, txnId);
    }
};

} // namespace table

using HypothesisGateway = db::TxnIdGatewayBase<table::Hypothesis>;
using HypothesisObjectGateway = db::TxnIdGatewayBase<table::HypothesisObject>;
using HypothesisFeedbackGateway = db::TxnIdGatewayBase<table::HypothesisFeedback>;

} // namespace eye

TABLE_TRAITS(eye::Hypothesis, eye::table::Hypothesis);
TABLE_TRAITS(eye::HypothesisObject, eye::table::HypothesisObject);
TABLE_TRAITS(eye::HypothesisFeedback, eye::table::HypothesisFeedback);

} // namespace maps::mrc::db::eye
