#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/traffic_signs/include/yandex/maps/mrc/traffic_signs/signs.h>

#include <maps/libs/common/include/exception.h>

#include <maps/libs/json/include/value.h>

namespace maps::mrc::db::eye {

enum class ObjectType {
    TrafficLight,
    Sign,
    RoadMarking,
    HouseNumber,
};

DECLARE_ENUM_IO(ObjectType);

using ObjectTypes = std::vector<ObjectType>;


struct TrafficLightAttrs {
    static constexpr ObjectType OBJECT_TYPE = ObjectType::TrafficLight;

    static TrafficLightAttrs fromJson(const json::Value& value);
    // Traffic light has no attributes
};

json::Value toJson(const TrafficLightAttrs& attrs);


struct SignAttrs {
    static constexpr ObjectType OBJECT_TYPE = ObjectType::Sign;

    static SignAttrs fromJson(const json::Value& value);

    traffic_signs::TrafficSign type;
    bool temporary;
};

json::Value toJson(const SignAttrs& attrs);


struct RoadMarkingAttrs {
    static constexpr ObjectType OBJECT_TYPE = ObjectType::RoadMarking;

    static RoadMarkingAttrs fromJson(const json::Value& value);

    traffic_signs::TrafficSign type;
};

json::Value toJson(const RoadMarkingAttrs& attrs);


struct HouseNumberAttrs {
    static constexpr ObjectType OBJECT_TYPE = ObjectType::HouseNumber;

    static HouseNumberAttrs fromJson(const json::Value& value);

    std::string number;
};

json::Value toJson(const HouseNumberAttrs& attrs);

} // namespace maps::mrc::db::eye
