#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/panorama_frame.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::eye {
namespace table {
using namespace  std::literals::string_view_literals;

struct PanoramaSessionToDevice: sql_chemistry::Table<eye::PanoramaSessionToDevice>{
    static constexpr std::string_view name_{"eye.panorama_session_to_device"sv};
    static constexpr sql_chemistry::UInt64Column sessionId{"session_id"sv, name_};
    static constexpr sql_chemistry::NumericColumn<TId> deviceId{"device_id"sv, name_};
    static constexpr sql_chemistry::FloatColumn deviation{"deviation"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(sessionId, deviceId, deviation);
    }
};

struct PanoramaToFrame: sql_chemistry::Table<eye::PanoramaToFrame> {
    static constexpr std::string_view name_{"eye.panorama_to_frame"sv};
    static constexpr sql_chemistry::StringColumn oid{"oid"sv, name_};
    static constexpr sql_chemistry::NumericColumn<TId> frameId{"frame_id"sv, name_};

    static constexpr sql_chemistry::FloatColumn heading{"heading"sv, name_};
    static constexpr sql_chemistry::FloatColumn tilt{"tilt"sv, name_};
    static constexpr sql_chemistry::FloatColumn hfov{"hfov"sv, name_};
    static constexpr sql_chemistry::Int16Column width{"width"sv, name_};
    static constexpr sql_chemistry::Int16Column height{"height"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(oid, frameId, heading, tilt, hfov, width, height);
    }
};

} // namespace table

using PanoramaSessionToDeviceGateway = sql_chemistry::Gateway<table::PanoramaSessionToDevice>;
using PanoramaToFrameGateway = sql_chemistry::Gateway<table::PanoramaToFrame>;

} // namespace maps::mrc::db::eye
