#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye_panorama.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>

namespace maps::mrc::db::eye {

enum class FrameSource;

struct MrcUrlContext {
    TId featureId;
    std::string mdsGroupId;
    std::string mdsPath;
};

struct PanoramaUrlContext {
    PanoramaOID oid;
    geolib3::Heading heading;
    geolib3::Degrees tilt;
    geolib3::Degrees horizontalFOV;
    common::Size size;
};

class UrlContext {
public:
    UrlContext(const json::Value& value);
    UrlContext(const MrcUrlContext& context);
    UrlContext(const PanoramaUrlContext& context);

    const json::Value& json() const;

    maps::mrc::db::eye::FrameSource source() const;

    MrcUrlContext mrc() const;
    PanoramaUrlContext panorama() const;

private:
    json::Value value_;
};

} // namespace maps::mrc::db::eye
