#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_location.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/txn_id.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

namespace maps::mrc::db {
namespace eye {
namespace table {

using namespace sql_chemistry;

struct VerifiedDetectionLocation: Table<db::eye::VerifiedDetectionLocation> {
    static constexpr std::string_view name_{"eye.verified_detection_location"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr EnumColumn<VerificationSource> source{"source", name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};
    static constexpr NumericColumn<TId> detectionId{"detection_id"sv, name_};
    static constexpr Nullable<MercatorColumn<geolib3::Point2>> position{"position"sv, name_};
    static constexpr Nullable<NumericArrayColumn<double>> rotation{"rotation"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id, source, txnId, detectionId, position, rotation);
    }
};

} // namespace table

using VerifiedDetectionLocationGateway = db::TxnIdGatewayBase<table::VerifiedDetectionLocation>;

} // namespace eye

TABLE_TRAITS(eye::VerifiedDetectionLocation, eye::table::VerifiedDetectionLocation);

} // namespace maps::mrc::db
