#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_missing_on_frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/txn_id.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

namespace maps::mrc::db {
namespace eye {
namespace table {

using namespace sql_chemistry;

struct VerifiedDetectionMissingOnFrame: Table<db::eye::VerifiedDetectionMissingOnFrame> {
    static constexpr std::string_view name_{"eye.verified_detection_missing_on_frame"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr EnumColumn<VerificationSource> source{"source", name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};
    static constexpr NumericColumn<TId> detectionId{"detection_id"sv, name_};
    static constexpr NumericColumn<TId> frameId{"frame_id"sv, name_};
    static constexpr NullableEnumColumn<VerifiedDetectionMissingOnFrameIsVisible> isVisible{"is_visible"sv, name_};
    static constexpr NullableEnumColumn<VerifiedDetectionMissingOnFrameMissingReason> missingReason{"missing_reason"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id, source, txnId, detectionId, frameId, isVisible, missingReason);
    }
};

struct VerifiedDetectionMissingOnFrameToTolokaTask: Table<db::eye::VerifiedDetectionMissingOnFrameToTolokaTask> {
    static constexpr std::string_view name_{"eye.verified_detection_missing_on_frame_to_toloka_task"sv};

    static constexpr NumericColumn<TId> verifiedTaskId{"verified_task_id"sv, name_};
    static constexpr NumericColumn<TId> tolokaTaskId{"toloka_task_id"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(verifiedTaskId, tolokaTaskId);
    }
};

} // namespace table

using VerifiedDetectionMissingOnFrameGateway = db::TxnIdGatewayBase<table::VerifiedDetectionMissingOnFrame>;
using VerifiedDetectionMissingOnFrameToTolokaTaskGateway = sql_chemistry::Gateway<table::VerifiedDetectionMissingOnFrameToTolokaTask>;

} // namespace eye

TABLE_TRAITS(eye::VerifiedDetectionMissingOnFrame, eye::table::VerifiedDetectionMissingOnFrame);
TABLE_TRAITS(eye::VerifiedDetectionMissingOnFrameToTolokaTask, eye::table::VerifiedDetectionMissingOnFrameToTolokaTask);

} // namespace maps::mrc::db::eye
