#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/txn_id.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verification_source.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <maps/libs/json/include/value.h>

#include <optional>
#include <string>
#include <utility>
#include <vector>

namespace maps::mrc::db::eye {

class VerifiedDetectionPairMatch {
public:
    VerifiedDetectionPairMatch(
            VerificationSource source,
            TId detectionId1,
            TId detectionId2,
            std::optional<bool> approved = std::nullopt);

    TId id() const { return id_; }

    VerificationSource source() const { return source_; }

    TId txnId() const { return txnId_; }

    TId detectionId1() const { return detectionId1_; }

    TId detectionId2() const { return detectionId2_; }

    std::optional<bool> approved() const { return approved_; }

    VerifiedDetectionPairMatch& setApproved(bool approved) {
        approved_ = approved;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<VerifiedDetectionPairMatch>;
    friend class TxnIdAccess<VerifiedDetectionPairMatch>;

    VerifiedDetectionPairMatch() {};

    VerifiedDetectionPairMatch& setTxnId(TId txnId) {
        txnId_ = txnId;
        return *this;
    }

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.id_, t.source_, t.txnId_, t.detectionId1_, t.detectionId2_, t.approved_);
    }

    TId id_;
    VerificationSource source_;
    TId txnId_;
    TId detectionId1_;
    TId detectionId2_;
    std::optional<bool> approved_;

public:
    auto introspect() const { return introspect(*this); }
};

class VerifiedDetectionPairMatchToTolokaTask {
public:
    VerifiedDetectionPairMatchToTolokaTask(
            TId verifiedTaskId,
            TId tolokaTaskId);

    TId verifiedTaskId() const { return verifiedTaskId_; }

    TId tolokaTaskId() const { return tolokaTaskId_; }

private:
    friend class sql_chemistry::GatewayAccess<VerifiedDetectionPairMatchToTolokaTask>;

    VerifiedDetectionPairMatchToTolokaTask() {};

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.verifiedTaskId_, t.tolokaTaskId_);
    }

    TId verifiedTaskId_;
    TId tolokaTaskId_;

public:
    auto introspect() const { return introspect(*this); }
};


using VerifiedDetectionPairMatches = std::vector<VerifiedDetectionPairMatch>;
using VerifiedDetectionPairMatchesToTolokaTasks = std::vector<VerifiedDetectionPairMatchToTolokaTask>;

} // namespace maps::mrc::db::eye
