#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_pair_match.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/txn_id.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

namespace maps::mrc::db {
namespace eye {
namespace table {

using namespace sql_chemistry;

struct VerifiedDetectionPairMatch: Table<db::eye::VerifiedDetectionPairMatch> {
    static constexpr std::string_view name_{"eye.verified_detection_pair_match"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr EnumColumn<VerificationSource> source{"source", name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};
    static constexpr NumericColumn<TId> detectionId1{"first_detection_id"sv, name_};
    static constexpr NumericColumn<TId> detectionId2{"second_detection_id"sv, name_};
    static constexpr NullableBooleanColumn approved{"approved"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id, source, txnId, detectionId1, detectionId2, approved);
    }
};

struct VerifiedDetectionPairMatchToTolokaTask: Table<db::eye::VerifiedDetectionPairMatchToTolokaTask> {
    static constexpr std::string_view name_{"eye.verified_detection_pair_match_to_toloka_task"sv};

    static constexpr NumericColumn<TId> verifiedTaskId{"verified_task_id"sv, name_};
    static constexpr NumericColumn<TId> tolokaTaskId{"toloka_task_id"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(verifiedTaskId, tolokaTaskId);
    }
};

} // namespace table

using VerifiedDetectionPairMatchGateway = db::TxnIdGatewayBase<table::VerifiedDetectionPairMatch>;
using VerifiedDetectionPairMatchToTolokaTaskGateway = sql_chemistry::Gateway<table::VerifiedDetectionPairMatchToTolokaTask>;

} // namespace eye

TABLE_TRAITS(eye::VerifiedDetectionPairMatch, eye::table::VerifiedDetectionPairMatch);
TABLE_TRAITS(eye::VerifiedDetectionPairMatchToTolokaTask, eye::table::VerifiedDetectionPairMatchToTolokaTask);

} // namespace maps::mrc::db::eye
