#pragma once

#include "eye_panorama.h"

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

// mds_key is unique key for a panorama
struct EyePanorama : Table<db::EyePanorama> {
    static constexpr std::string_view name_{"signals.eye_panorama"sv};
    static constexpr StringPrimaryKey oid{"oid"sv, name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};
    static constexpr TimePointColumn date{"date"sv, name_};
    static constexpr Int64Column sessionId{"session_id"sv, name_};
    static constexpr Int32Column orderNum{"order_num"sv, name_};
    static constexpr GeodeticColumn<geolib3::Point2> position{"position"sv, name_};
    static constexpr FloatColumn vehicleCourseDeg{"vehicle_course_deg"sv, name_};
    static constexpr BooleanColumn deleted{"deleted"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(
            oid,
            txnId,
            date,
            sessionId,
            orderNum,
            position,
            vehicleCourseDeg,
            deleted);
    }
};

} // namespace table

using EyePanoramaGateway = db::TxnIdGatewayBase<table::EyePanorama>;

} // namespace maps::mrc::db
