#pragma once

#include "common.h"
#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <vector>

namespace maps::mrc::db {

class FeatureTransaction {
public:
    FeatureTransaction(TId featureId, TId transactionId)
        : featureId_(featureId)
        , transactionId_(transactionId)
    {}

    TId featureId() const { return featureId_; }

    TId transactionId() const { return transactionId_; }

    FeatureTransaction& setTransacrionId(TId transactionId) {
        transactionId_ = transactionId;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<FeatureTransaction>;

    FeatureTransaction() = default;

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.featureId_, t.transactionId_); }

    TId featureId_{0};
    TId transactionId_{0};

public:
    auto introspect() const { return introspect(*this); }
};

using FeatureTransactions = std::vector<FeatureTransaction>;

} // namespace maps::mrc::db
