#pragma once

#include "house_number.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct HouseNumber : Table<db::HouseNumber> {
    static constexpr std::string_view name_{"house.house_number"};

    static constexpr BigSerialKey id{"house_number_id", name_};
    static constexpr StringColumn number{"number", name_};
    static constexpr MercatorColumn<geolib3::Point2> position{"position", name_};
    static constexpr NullableNumericColumn<TId> feedbackTaskId{ "feedback_task_id", name_ };

    static constexpr auto columns_() {
        return std::tie(id, number, position, feedbackTaskId);
    }
};

struct HouseNumberFeature : Table<db::HouseNumberFeature> {
    static constexpr std::string_view name_{"house.house_number_feature"};

    static constexpr NumericColumn<TId> houseNumberId{"house_number_id", name_};
    static constexpr NumericColumn<TId> featureId{"feature_id", name_};
    static constexpr NumericColumn<size_t> minX{"min_x", name_};
    static constexpr NumericColumn<size_t> minY{"min_y", name_};
    static constexpr NumericColumn<size_t> maxX{"max_x", name_};
    static constexpr NumericColumn<size_t> maxY{"max_y", name_};

    static constexpr auto columns_() { return std::tie(houseNumberId, featureId, minX, minY, maxX, maxY); }
};

struct HouseNumberPanorama : Table<db::HouseNumberPanorama> {
    static constexpr std::string_view name_{"house.house_number_panorama"};

    static constexpr NumericColumn<TId> houseNumberId{"house_number_id", name_};
    static constexpr NumericColumn<TId> panoramaId{"panorama_id", name_};
    static constexpr NumericColumn<size_t> minX{"min_x", name_};
    static constexpr NumericColumn<size_t> minY{"min_y", name_};
    static constexpr NumericColumn<size_t> maxX{"max_x", name_};
    static constexpr NumericColumn<size_t> maxY{"max_y", name_};

    static constexpr auto columns_() { return std::tie(houseNumberId, panoramaId, minX, minY, maxX, maxY); }
};

struct HouseNumberToloka : Table<db::HouseNumberToloka> {
    static constexpr std::string_view name_{"house.house_number_toloka"};

    static constexpr Int64PrimaryKey houseNumberId{"house_number_id", name_};
    static constexpr StringColumn workflowId{"workflow_id", name_};
    static constexpr StringColumn workflowInstanceId{"workflow_instance_id", name_};
    static constexpr StringColumn blockGUID{"block_guid", name_};
    static constexpr StringColumn state{"state", name_};

    static constexpr auto columns_() {
        return std::tie(houseNumberId, workflowId, workflowInstanceId, blockGUID, state);
    }
};

} // namespace table

using HouseNumberGateway = sql_chemistry::Gateway<table::HouseNumber>;
using HouseNumberFeatureGateway = sql_chemistry::Gateway<table::HouseNumberFeature>;
using HouseNumberPanoramaGateway = sql_chemistry::Gateway<table::HouseNumberPanorama>;
using HouseNumberTolokaGateway = sql_chemistry::Gateway<table::HouseNumberToloka>;

} // namespace maps::mrc::db
