#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/hypothesis.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct Hypothesis : Table<db::Hypothesis> {
    static constexpr std::string_view name_{"signs_detect.hypotheses"sv};

    static constexpr BigSerialKey id{"hypothesis_id"sv, name_};
    static constexpr EnumColumn<HypothesisType> type{"type"sv, name_};
    static constexpr MercatorColumn<geolib3::Point2> position{"position"sv, name_};
    static constexpr NumericColumn<TId> objectId{"object_id"sv, name_};
    static constexpr NumericColumn<TId> commitId{"commit_id"sv, name_};
    static constexpr NumericColumn<TId> signId{"sign_id"sv, name_};
    static constexpr JsonColumn context{"context"sv, name_};
    static constexpr NumericColumn<TId> feedbackTaskId{"feedback_task_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, type, position, objectId, commitId, signId, context, feedbackTaskId);
    }
};

} // namespace table

using HypothesisGateway = sql_chemistry::Gateway<table::Hypothesis>;

TABLE_TRAITS(Hypothesis, table::Hypothesis);

} // namespace maps::mrc::db
