#pragma once

#include "common.h"
#include "import_config.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {

using namespace sql_chemistry;

struct ImportConfig : Table<db::ImportConfig> {
    static constexpr std::string_view name_{"service.import_config"sv};

    static constexpr PrimaryKey<EnumColumn<Dataset>> dataset{"dataset"sv, name_};
    static constexpr Int64PrimaryKey geoId{"geo_id"sv, name_};
    static constexpr Int16PrimaryKey fc{"fc"sv, name_};
    static constexpr NumericColumn<size_t> thresholdDays{"threshold_days"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(dataset, geoId, fc, thresholdDays);
    }
};

} // namespace table

using ImportConfigGateway = sql_chemistry::Gateway<table::ImportConfig>;

} // namespace maps::mrc::db
