#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <vector>

namespace maps::mrc::db {

/**
 * Configures taxi event types which should be imported
 * and pre-event video durations for those events.
 */
class ImportTaxiEventConfig {
public:
    ImportTaxiEventConfig(
        std::string eventType,
        size_t secondsBefore
    )
        : eventType_(std::move(eventType))
        , secondsBefore_(secondsBefore)
    {}

    const std::string& eventType() const { return eventType_; }

    size_t secondsBefore() const { return secondsBefore_; }

private:
    friend class sql_chemistry::GatewayAccess<ImportTaxiEventConfig>;
    ImportTaxiEventConfig() = default;

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.eventType_, t.secondsBefore_);
    }

    std::string eventType_;
    size_t secondsBefore_;

public:
    auto introspect() const { return introspect(*this); }
};

using ImportTaxiEventConfigs = std::vector<ImportTaxiEventConfig>;

} // namespace maps::mrc::db
