#pragma once

#include "common.h"
#include "import_taxi_event_config.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {

using namespace sql_chemistry;

struct ImportTaxiEventConfig : Table<db::ImportTaxiEventConfig> {
    static constexpr std::string_view name_{"service.import_taxi_event_config"sv};

    static constexpr StringPrimaryKey eventType{"event_type"sv, name_};
    static constexpr NumericColumn<size_t> secondsBefore{"seconds_before"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(eventType, secondsBefore);
    }
};

} // namespace table

using ImportTaxiEventConfigGateway = sql_chemistry::Gateway<table::ImportTaxiEventConfig>;

} // namespace maps::mrc::db
