#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <boost/lexical_cast.hpp>
#include <string>

namespace maps::mrc::db {

class Metadata {
public:
    template <typename T>
    Metadata(std::string key, T&& value)
        : key_(std::move(key)) {
        setValue(std::forward<T>(value));
        REQUIRE(!key_.empty(), "Key should not be empty.");
    }

    const std::string& key() const { return key_; }

    const std::string& value() const { return value_; }

    template <typename T>
    T value() const { return boost::lexical_cast<T>(value_); }

    Metadata& setValue(std::string value) {
        value_ = move(value);
        return *this;
    }

    template <typename T>
    Metadata& setValue(T&& value) {
        value_ = boost::lexical_cast<std::string>(std::forward<T>(value));
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<Metadata>;

    Metadata() = default;

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.key_, t.value_); }

    std::string key_{};
    std::string value_{};

public:
    auto introspect() const { return introspect(*this); }
};

} // namespace maps::mrc::db
