#pragma once

#include "common.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/metadata.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct Metadata : Table<db::Metadata> {
    static constexpr std::string_view name_{"targets.metadata"sv};

    static constexpr StringPrimaryKey key{"key"sv, name_}; // not null PRIMARY KEY
    static constexpr StringColumn value{"value"sv, name_};

    static constexpr auto columns_() { return std::tie(key, value); }
};

} // namespace table

class MetadataGateway : public sql_chemistry::Gateway<table::Metadata> {
public:
    using Gateway<table::Metadata>::Gateway;

    /// Returns empty string when key not found.
    std::optional<std::string> tryLoadByKey(std::string key) {
        if (auto es = tryLoadById(std::move(key))) {
            return es->value();
        }
        return std::nullopt;
    }

    /// Returns default value when key not found.
    template <class T>
    T tryLoadByKey(std::string key, T defaultValue) {
        if (auto es = tryLoadById(std::move(key))) {
            return es->value<T>();
        }
        return defaultValue;
    }

    /// Throws when key not found.
    template <class T>
    T loadByKey(std::string key) {
        return loadById(std::move(key)).value<T>();
    }

    /// Update existing value or insert new one.
    template <class T>
    void upsertByKey(std::string key, T val) {
        Metadata e(std::move(key), std::move(val));
        upsert(e);
    }
};

} // namespace maps::mrc::db
