#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::mrc::db {


class NexarFrameToFeature {
public:
    NexarFrameToFeature(std::string frameId, db::TId featureId)
        : frameId_(std::move(frameId))
        , featureId_(featureId)
    {
        REQUIRE(!frameId_.empty(), "frameId mustn't be empty");
    }

    const std::string& frameId() const { return frameId_; }
    db::TId featureId() const { return featureId_; }


private:
    friend class sql_chemistry::GatewayAccess<NexarFrameToFeature>;

    NexarFrameToFeature() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.frameId_, t.featureId_);
    }

    std::string frameId_;
    db::TId featureId_;

public:
    auto introspect() const { return introspect(*this); }
};

using NexarFrameToFeatures = std::vector<NexarFrameToFeature>;

} // namespace maps::mrc::db
