#pragma once

#include "nexar_frame_to_feature.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {

namespace table {
using namespace sql_chemistry;

struct NexarFrameToFeatureTable : Table<db::NexarFrameToFeature> {

    static constexpr std::string_view name_{"signals.nexar_frame_to_feature"sv};

    static constexpr StringPrimaryKey frameId{"nexar_frame_id"sv, name_};
    static constexpr Int64Column featureId{"feature_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(frameId, featureId);
    }
};

} // namespace table

using NexarFrameToFeatureGateway = sql_chemistry::Gateway<table::NexarFrameToFeatureTable>;

} // namespace maps::mrc::db
