#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/image_box.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/introspection/include/stream_output.h>

#include <cstdint>

namespace maps::mrc::db {


class NexarImportTileUpdateInfo {
public:
    NexarImportTileUpdateInfo(
        int32_t geoId,
        int16_t fc,
        int32_t x,
        int32_t y,
        int32_t z,
        std::optional<chrono::TimePoint> checkedAt = {},
        std::optional<int32_t> medianPhotoAgeDays = {})
        : geoId_(geoId)
        , fc_(fc)
        , x_(x)
        , y_(y)
        , z_(z)
        , checkedAt_(std::move(checkedAt))
        , medianPhotoAgeDays_(std::move(medianPhotoAgeDays))
    {}

    int32_t geoId() const { return geoId_; }
    int16_t fc() const { return fc_; }
    int32_t x() const { return x_; }
    int32_t y() const { return y_; }
    int32_t z() const { return z_; }
    std::optional<chrono::TimePoint> checkedAt() const { return checkedAt_; }
    std::optional<int32_t> medianPhotoAgeDays() const {return medianPhotoAgeDays_; }

    NexarImportTileUpdateInfo& setCheckedAt(chrono::TimePoint checkedAt)
    {
        checkedAt_ = std::move(checkedAt);
        return *this;
    }

    NexarImportTileUpdateInfo& setMedianPhotoAgeDays(std::optional<int32_t> value)
    {
        medianPhotoAgeDays_ = std::move(value);
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<NexarImportTileUpdateInfo>;

    NexarImportTileUpdateInfo() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.geoId_, t.fc_, t.x_, t.y_, t.z_,
            t.checkedAt_, t.medianPhotoAgeDays_);
    }

    int32_t geoId_;
    int16_t fc_;
    int32_t x_;
    int32_t y_;
    int32_t z_;
    std::optional<chrono::TimePoint> checkedAt_;
    std::optional<int32_t> medianPhotoAgeDays_;

public:
    auto introspect() const { return introspect(*this); }
};

using NexarImportTileUpdateInfos = std::vector<NexarImportTileUpdateInfo>;

} // namespace maps::mrc::db
