#pragma once

#include "nexar_import_tile_update_info.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {

namespace table {
using namespace sql_chemistry;

struct NexarImportTileUpdateInfoTable : Table<db::NexarImportTileUpdateInfo> {

    static constexpr std::string_view name_{"service.nexar_import_tile_update_info"sv};

    static constexpr Int32PrimaryKey geoId{"geo_id"sv, name_};
    static constexpr Int16PrimaryKey fc{"fc"sv, name_};
    static constexpr Int32PrimaryKey x{"x"sv, name_};
    static constexpr Int32PrimaryKey y{"y"sv, name_};
    static constexpr Int32PrimaryKey z{"z"sv, name_};
    static constexpr Nullable<TimePointColumn> checkedAt{"checked_at"sv, name_};
    static constexpr Nullable<NumericColumn<int16_t>> medianPhotoAgeDays{"median_photo_age_days"sv, name_};

    static constexpr auto columns_() {
        return std::tie(geoId, fc, x, y, z, checkedAt, medianPhotoAgeDays);
    }
};

} // namespace table

using NexarImportTileUpdateInfoGateway = sql_chemistry::Gateway<table::NexarImportTileUpdateInfoTable>;

} // namespace maps::mrc::db
