#pragma once

#include "object_in_photo.h"
#include "table_traits.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {

namespace table {
using namespace sql_chemistry;

struct ObjectInPhotoTable : Table<db::ObjectInPhoto> {

    static constexpr std::string_view name_{"signals.object_in_photo"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr NumericColumn<TId> featureId{"feature_id"sv, name_};
    static constexpr EnumColumn<ObjectInPhotoType> type{"type"sv, name_};
    static constexpr NumericColumn<int32_t> minX{"min_x"sv, name_};
    static constexpr NumericColumn<int32_t> minY{"min_y"sv, name_};
    static constexpr NumericColumn<int32_t> maxX{"max_x"sv, name_};
    static constexpr NumericColumn<int32_t> maxY{"max_y"sv, name_};
    static constexpr FloatColumn confidence{"confidence"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, featureId, type, minX, minY, maxX, maxY, confidence);
    }
};

} // namespace table

using ObjectInPhotoGateway = sql_chemistry::Gateway<table::ObjectInPhotoTable>;

TABLE_TRAITS(ObjectInPhoto, table::ObjectInPhotoTable);

} // namespace maps::mrc::db
