#pragma once

#include "panorama.h"

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

// mds_key is unique key for a panorama
struct Panorama : Table<db::Panorama> {
    static constexpr std::string_view name_{"signals.panorama"sv};
    static constexpr BigSerialKey panoramaId{"panorama_id"sv, name_};
    static constexpr StringColumn mdsKey{"mds_key"sv, name_};
    static constexpr StringColumn mdsSrcKey{"mds_src_key"sv, name_};
    static constexpr TimePointColumn date{"date"sv, name_};
    static constexpr Int64Column sessionId{"session_id"sv, name_};
    static constexpr Int32Column orderNum{"order_num"sv, name_};
    static constexpr GeodeticColumn<geolib3::Point2> position{"position"sv, name_};
    static constexpr FloatColumn vehicleCourseDeg{"vehicle_course_deg"sv, name_};
    static constexpr FloatColumn horizontalAngleDeg{"horizontal_angle_deg"sv, name_};
    static constexpr FloatColumn verticalAngleDeg{"vertical_angle_deg"sv, name_};
    static constexpr Int32Column tileWidth{"tile_width"sv, name_};
    static constexpr Int32Column tileHeight{"tile_height"sv, name_};
    static constexpr Int32Column totalWidth{"total_width"sv, name_};
    static constexpr Int32Column totalHeight{"total_height"sv, name_};
    static constexpr Int16Column zoomLevel{"zoom_level"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(panoramaId, mdsKey, mdsSrcKey, date, sessionId,
            orderNum, position, vehicleCourseDeg, horizontalAngleDeg,
            verticalAngleDeg, tileWidth, tileHeight, totalWidth, totalHeight,
            zoomLevel);
    }
};

} // namespace table

using PanoramaGateway = sql_chemistry::Gateway<table::Panorama>;

} // namespace maps::mrc::db
