#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <vector>

namespace maps::mrc::db::rides {

class QueuedPhotoId {
public:
    QueuedPhotoId(TId photoId, chrono::TimePoint receivedAt)
        : photoId_{photoId}
        , receivedAt_{receivedAt} {}

    TId photoId() const { return photoId_; }

    chrono::TimePoint receivedAt() const { return receivedAt_; }

private:
    friend class sql_chemistry::GatewayAccess<QueuedPhotoId>;

    QueuedPhotoId() = default;

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.photoId_, t.receivedAt_); }

    TId photoId_;
    chrono::TimePoint receivedAt_;

public:
    auto introspect() const { return introspect(*this); }
};

using QueuedPhotoIds = std::vector<QueuedPhotoId>;

} // namespace maps::mrc::db::rides
