#pragma once

#include "queued_photo_id.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct QueuedPhotoId : Table<db::rides::QueuedPhotoId> {
    static constexpr std::string_view name_{"rides.queued_photo_id"sv};

    // not null UNIQUE FOREIGN KEY signals.feature
    static constexpr Int64PrimaryKey photoId{"photo_id"sv, name_};
    static constexpr TimePointColumn receivedAt{"received_at"sv, name_};

    static constexpr auto columns_() { return std::tie(photoId, receivedAt); }
};

} // namespace table

using QueuedPhotoIdGateway = sql_chemistry::Gateway<table::QueuedPhotoId>;

} // namespace maps::mrc::db
