#pragma once

#include <yandex/maps/mds/mds.h>
#include "common.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <string>
#include <vector>

namespace maps::mrc::db::rides {

class RideRecordingReport {
public:
    RideRecordingReport(
        std::string sourceId,
        chrono::TimePoint startedAt,
        chrono::TimePoint finishedAt)
        : id_(0)
        , sourceId_(std::move(sourceId))
        , startedAt_(startedAt)
        , finishedAt_(finishedAt) {}

    TId id() const { return id_; }

    const std::string& sourceId() const { return sourceId_; }

    const std::string& mdsGroupId() const { return mdsGroupId_; }

    const std::string& mdsPath() const { return mdsPath_; }

    chrono::TimePoint startedAt() const { return startedAt_; }

    chrono::TimePoint finishedAt() const { return finishedAt_; }

    RideRecordingReport& setMdsGroupId(std::string mdsGroupId) {
        mdsGroupId_ = std::move(mdsGroupId);
        return *this;
    }

    RideRecordingReport& setMdsPath(std::string mdsPath) {
        mdsPath_ = std::move(mdsPath);
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<RideRecordingReport>;
    RideRecordingReport() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.sourceId_, t.mdsGroupId_, t.mdsPath_, t.startedAt_, t.finishedAt_);
    }

    TId id_{};
    std::string sourceId_{};
    std::string mdsGroupId_{};
    std::string mdsPath_{};
    chrono::TimePoint startedAt_{};
    chrono::TimePoint finishedAt_{};

public:
    auto introspect() const { return introspect(*this); }
};

using RideRecordingReports = std::vector<RideRecordingReport>;

} // namespace maps::mrc::db::rides
