#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ride_recording_report.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::rides {
namespace table {
using namespace sql_chemistry;

struct RideRecordingReport : Table<db::rides::RideRecordingReport> {
    static constexpr std::string_view name_{"rides.ride_recording_report"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn sourceId{"source_id"sv, name_};
    static constexpr StringColumn mdsGroupId{"mds_group_id"sv, name_};
    static constexpr StringColumn mdsPath{"mds_path"sv, name_};
    static constexpr TimePointColumn startedAt{"started_at"sv, name_};
    static constexpr TimePointColumn finishedAt{"finished_at"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, sourceId, mdsGroupId, mdsPath, startedAt, finishedAt);
    }
};

} // namespace table

using RideRecordingReportGateway = sql_chemistry::Gateway<table::RideRecordingReport>;

} // namespace maps::mrc::db::rides
