#pragma once

#include <type_traits>

namespace maps::mrc::db {

template<class T>
struct TableTraits;

// Specialize table, using macros
#define TABLE_TRAITS(E, T) \
template<> \
struct TableTraits<E> { \
    using Table = T; \
}; \


template<class T, class E = void>
struct HasTable: std::false_type {};

template<class T>
struct HasTable<T, std::void_t<typename TableTraits<T>::Table>>: std::true_type {};

template<class T>
constexpr bool hasTable = HasTable<T>::value;

} // namespace maps::mrc::db
