#pragma once

#include "takeout_data_erasure.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {

namespace table {

using namespace sql_chemistry;

struct TakeoutDataErasure : Table<db::TakeoutDataErasure> {
    static constexpr std::string_view name_{"service.takeout_data_erasure"};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn takeoutRequestId{"takeout_request_id"sv,
                                                   name_};
    static constexpr StringColumn userId{"user_id", name_};
    static constexpr TimePointColumn requestedAt{"requested_at", name_};
    static constexpr NullableTimePointColumn finishedAt{"finished_at", name_};
    static constexpr NullableStringColumn grinderTaskId{"grinder_task_id",
                                                        name_};

    static constexpr auto columns_()
    {
        return std::tie(id,
                        takeoutRequestId,
                        userId,
                        requestedAt,
                        finishedAt,
                        grinderTaskId);
    }
};

}  // namespace table

using TakeoutDataErasureGateway =
    sql_chemistry::Gateway<table::TakeoutDataErasure>;

}  // namespace maps::mrc::db
