#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <utility>
#include <vector>

namespace maps::mrc::db {

class TakeoutOngoingJob {
public:
    TakeoutOngoingJob(std::string jobId, std::string uid, std::string grinderTaskId,
                      chrono::TimePoint startedAt)
        : jobId_(std::move(jobId))
        , uid_(std::move(uid))
        , grinderTaskId_(std::move(grinderTaskId))
        , startedAt_(startedAt)
    {}

    const std::string& jobId() const { return jobId_; }

    const std::string& uid() const { return uid_; }

    const std::string& grinderTaskId() const { return grinderTaskId_; }

    chrono::TimePoint startedAt() const { return startedAt_; }

    TakeoutOngoingJob& setStartedAt(chrono::TimePoint startedAt)
    {
        startedAt_ = startedAt;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<TakeoutOngoingJob>;

    TakeoutOngoingJob() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.jobId_, t.uid_, t.grinderTaskId_, t.startedAt_);
    }

    std::string jobId_{};
    std::string uid_{};
    std::string grinderTaskId_{};
    chrono::TimePoint startedAt_{};

public:
    auto introspect() const { return introspect(*this); }
};

} // namespace maps::mrc::db
