#pragma once

#include "takeout_ongoing_job.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {

namespace table {
using namespace sql_chemistry;

struct TakeoutOngoingJob : Table<db::TakeoutOngoingJob> {
    static constexpr std::string_view name_{"service.takeout_ongoing_job"};

    static constexpr StringPrimaryKey jobId{"job_id", name_};
    static constexpr StringColumn uid{"uid", name_};
    static constexpr StringColumn grinderTaskId{"grinder_task_id", name_};
    static constexpr TimePointColumn startedAt{"started_at", name_};

    static constexpr auto columns_() { return std::tie(jobId, uid, grinderTaskId, startedAt); }
};

} // namespace table

using TakeoutOngoingJobGateway = sql_chemistry::Gateway<table::TakeoutOngoingJob>;

} // namespace maps::mrc::db
