#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <string>
#include <vector>

namespace maps::mrc::db::toloka {

/// Represents items in toloka_mgr.mds_file table which stores mds keys of files stored in MDS.
class MdsFile {
public:
    MdsFile(TId taskId, std::string mdsGroupId, std::string mdsPath)
        : taskId_(taskId)
        , mdsGroupId_(std::move(mdsGroupId))
        , mdsPath_(std::move(mdsPath)) {
    }

    TId id() const { return id_; }

    TId taskId() const { return taskId_; }

    const std::string& mdsGroupId() const { return mdsGroupId_; }

    const std::string& mdsPath() const { return mdsPath_; }

private:
    friend class sql_chemistry::GatewayAccess<MdsFile>;
    MdsFile() = default;

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.id_, t.taskId_, t.mdsGroupId_, t.mdsPath_); }

    TId id_{};
    TId taskId_{};
    std::string mdsGroupId_{};
    std::string mdsPath_{};

public:
    auto introspect() const { return introspect(*this); }
};

using MdsFiles = std::vector<MdsFile>;

} // namespace maps::mrc::db::toloka
